/**
 * @file xmc1_usic_map.h
 * @date 2016-08-22
 *
 * @cond
 *********************************************************************************************************************
 * XMClib v2.1.16 - XMC Peripheral Driver Library 
 *
 * Copyright (c) 2015-2017, Infineon Technologies AG
 * All rights reserved.                        
 *                                             
 * Redistribution and use in source and binary forms, with or without modification,are permitted provided that the 
 * following conditions are met:   
 *                                                                              
 * Redistributions of source code must retain the above copyright notice, this list of conditions and the following 
 * disclaimer.                        
 * 
 * Redistributions in binary form must reproduce the above copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials provided with the distribution.                       
 * 
 * Neither the name of the copyright holders nor the names of its contributors may be used to endorse or promote 
 * products derived from this software without specific prior written permission.                                           
 *                                                                              
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, 
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE  
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE  FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR  
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY,OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                                                  
 *                                                                              
 * To improve the quality of the software, users are encouraged to share modifications, enhancements or bug fixes with 
 * Infineon Technologies AG dave@infineon.com).                                                          
 *********************************************************************************************************************
 *
 * Change History
 * --------------
 *
 * 2015-02-20:
 *     - Initial version
 *
 * 2015-08-25:
 *     - Added XMC1400
 *
 * 2016-06-17:
 *     - Added support for XMC1201 TSSOP28, XMC1302 TSSOP28, XMC1402 TSSOP38, XMC1403 VQFN40
 *
 * 2016-08-22:
 *     - Added USIC1_C0_DX1_P3_4 for XMC14xx 64 pins package
 *
 * @endcond 
 *
 */

#ifndef XMC1_USIC_MAP_H
#define XMC1_USIC_MAP_H

/**********************************************************************************************************************
 * MACROS
 *********************************************************************************************************************/

#define USIC_INPUT_ALWAYS_1     7

#if (UC_DEVICE == XMC1100) && (UC_PACKAGE == VQFN24)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1100) && (UC_PACKAGE == VQFN40)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1100) && (UC_PACKAGE == TSSOP16)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1100) && (UC_PACKAGE == TSSOP38)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1200) && (UC_PACKAGE == TSSOP38)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1201) && (UC_PACKAGE == VQFN40)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1201) && (UC_PACKAGE == TSSOP28)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1201) && (UC_PACKAGE == TSSOP38)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1202) && (UC_PACKAGE == VQFN24)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1202) && (UC_PACKAGE == VQFN40)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1202) && (UC_PACKAGE == TSSOP16)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1202) && (UC_PACKAGE == TSSOP28)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == VQFN24)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == VQFN40)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == TSSOP16)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1301) && (UC_PACKAGE == TSSOP38)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == VQFN24)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == VQFN40)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == TSSOP16)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == TSSOP28)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1302) && (UC_PACKAGE == TSSOP38)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#endif


#if (UC_DEVICE == XMC1401) && (UC_PACKAGE == LQFP64)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#define USIC1_C0_DX0_DX3INS 	6
#define USIC1_C0_DX0_P0_2   	0
#define USIC1_C0_DX0_P0_3   	1
#define USIC1_C0_DX0_P3_3   	4
#define USIC1_C0_DX0_P3_4   	5
#define USIC1_C0_DX0_P4_4   	2
#define USIC1_C0_DX0_P4_5   	3
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_DX4INS 	6
#define USIC1_C0_DX1_P0_2   	0
#define USIC1_C0_DX1_P3_4   	4
#define USIC1_C0_DX1_P4_3   	1
#define USIC1_C0_DX1_P4_5   	2
#define USIC1_C0_DX1_P4_6   	3
#define USIC1_C0_DX2_DX5INS 	6
#define USIC1_C0_DX2_P3_1   	5
#define USIC1_C0_DX2_P4_10  	3
#define USIC1_C0_DX2_P4_11  	4
#define USIC1_C0_DX2_P4_7   	0
#define USIC1_C0_DX2_P4_8   	1
#define USIC1_C0_DX2_P4_9   	2
#define USIC1_C0_DX3_DOUT0  	6
#define USIC1_C0_DX3_DX5INS 	5
#define USIC1_C0_DX3_P1_8   	1
#define USIC1_C0_DX3_P2_12  	0
#define USIC1_C0_DX3_P2_3   	4
#define USIC1_C0_DX3_P3_2   	2
#define USIC1_C0_DX3_P4_0   	3
#define USIC1_C0_DX4_DX5INS 	5
#define USIC1_C0_DX4_P1_8   	1
#define USIC1_C0_DX4_P2_12  	0
#define USIC1_C0_DX4_P2_3   	4
#define USIC1_C0_DX4_P3_2   	2
#define USIC1_C0_DX4_P4_0   	3
#define USIC1_C0_DX4_SCLKOUT	6
#define USIC1_C0_DX5_P1_7   	1
#define USIC1_C0_DX5_P2_13  	0
#define USIC1_C0_DX5_P2_2   	4
#define USIC1_C0_DX5_P2_4   	5
#define USIC1_C0_DX5_P4_1   	2
#define USIC1_C0_DX5_P4_2   	3
#define USIC1_C0_DX5_SELO0  	6
#define USIC1_C1_DX0_DX3INS 	6
#define USIC1_C1_DX0_P0_0   	0
#define USIC1_C1_DX0_P0_1   	1
#define USIC1_C1_DX0_P2_12  	2
#define USIC1_C1_DX0_P2_13  	3
#define USIC1_C1_DX0_P3_0   	4
#define USIC1_C1_DX0_P3_1   	5
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_DX4INS 	6
#define USIC1_C1_DX1_P0_1   	0
#define USIC1_C1_DX1_P1_8   	2
#define USIC1_C1_DX1_P2_12  	1
#define USIC1_C1_DX1_P3_0   	3
#define USIC1_C1_DX2_DX5INS 	6
#define USIC1_C1_DX2_P1_7   	2
#define USIC1_C1_DX2_P3_3   	0
#define USIC1_C1_DX2_P3_4   	1
#define USIC1_C1_DX2_SR0    	5
#define USIC1_C1_DX3_DOUT0  	6
#define USIC1_C1_DX3_DX5INS 	5
#define USIC1_C1_DX3_P0_15  	1
#define USIC1_C1_DX3_P2_4   	2
#define USIC1_C1_DX3_P2_6   	4
#define USIC1_C1_DX3_P3_2   	3
#define USIC1_C1_DX3_P4_11  	0
#define USIC1_C1_DX4_DX5INS 	5
#define USIC1_C1_DX4_P0_15  	1
#define USIC1_C1_DX4_P2_4   	2
#define USIC1_C1_DX4_P2_6   	4
#define USIC1_C1_DX4_P3_2   	3
#define USIC1_C1_DX4_P4_11  	0
#define USIC1_C1_DX4_SCLKOUT	6
#define USIC1_C1_DX5_P0_14  	1
#define USIC1_C1_DX5_P2_3   	2
#define USIC1_C1_DX5_P2_5   	3
#define USIC1_C1_DX5_P2_7   	4
#define USIC1_C1_DX5_P4_10  	0
#define USIC1_C1_DX5_P4_4   	5
#define USIC1_C1_DX5_SELO0  	6
#endif


#if (UC_DEVICE == XMC1401) && (UC_PACKAGE == VQFN48)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#define USIC1_C0_DX0_DX3INS 	6
#define USIC1_C0_DX0_P0_2   	0
#define USIC1_C0_DX0_P0_3   	1
#define USIC1_C0_DX0_P4_4   	2
#define USIC1_C0_DX0_P4_5   	3
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_DX4INS 	6
#define USIC1_C0_DX1_P0_2   	0
#define USIC1_C0_DX1_P4_5   	2
#define USIC1_C0_DX1_P4_6   	3
#define USIC1_C0_DX2_DX5INS 	6
#define USIC1_C0_DX2_P4_7   	0
#define USIC1_C0_DX3_DOUT0  	6
#define USIC1_C0_DX3_DX5INS 	5
#define USIC1_C0_DX3_P2_12  	0
#define USIC1_C0_DX3_P2_3   	4
#define USIC1_C0_DX4_DX5INS 	5
#define USIC1_C0_DX4_P2_12  	0
#define USIC1_C0_DX4_P2_3   	4
#define USIC1_C0_DX4_SCLKOUT	6
#define USIC1_C0_DX5_P2_13  	0
#define USIC1_C0_DX5_P2_2   	4
#define USIC1_C0_DX5_P2_4   	5
#define USIC1_C0_DX5_SELO0  	6
#define USIC1_C1_DX0_DX3INS 	6
#define USIC1_C1_DX0_P0_0   	0
#define USIC1_C1_DX0_P0_1   	1
#define USIC1_C1_DX0_P2_12  	2
#define USIC1_C1_DX0_P2_13  	3
#define USIC1_C1_DX0_P3_0   	4
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_DX4INS 	6
#define USIC1_C1_DX1_P0_1   	0
#define USIC1_C1_DX1_P2_12  	1
#define USIC1_C1_DX1_P3_0   	3
#define USIC1_C1_DX2_DX5INS 	6
#define USIC1_C1_DX2_SR0    	5
#define USIC1_C1_DX3_DOUT0  	6
#define USIC1_C1_DX3_DX5INS 	5
#define USIC1_C1_DX3_P0_15  	1
#define USIC1_C1_DX3_P2_4   	2
#define USIC1_C1_DX3_P2_6   	4
#define USIC1_C1_DX4_DX5INS 	5
#define USIC1_C1_DX4_P0_15  	1
#define USIC1_C1_DX4_P2_4   	2
#define USIC1_C1_DX4_P2_6   	4
#define USIC1_C1_DX4_SCLKOUT	6
#define USIC1_C1_DX5_P0_14  	1
#define USIC1_C1_DX5_P2_3   	2
#define USIC1_C1_DX5_P2_5   	3
#define USIC1_C1_DX5_P2_7   	4
#define USIC1_C1_DX5_P4_4   	5
#define USIC1_C1_DX5_SELO0  	6
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == LQFP64)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#define USIC1_C0_DX0_DX3INS 	6
#define USIC1_C0_DX0_P0_2   	0
#define USIC1_C0_DX0_P0_3   	1
#define USIC1_C0_DX0_P3_3   	4
#define USIC1_C0_DX0_P3_4   	5
#define USIC1_C0_DX0_P4_4   	2
#define USIC1_C0_DX0_P4_5   	3
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_DX4INS 	6
#define USIC1_C0_DX1_P0_2   	0
#define USIC1_C0_DX1_P3_4   	4
#define USIC1_C0_DX1_P4_3   	1
#define USIC1_C0_DX1_P4_5   	2
#define USIC1_C0_DX1_P4_6   	3
#define USIC1_C0_DX2_DX5INS 	6
#define USIC1_C0_DX2_P3_1   	5
#define USIC1_C0_DX2_P4_10  	3
#define USIC1_C0_DX2_P4_11  	4
#define USIC1_C0_DX2_P4_7   	0
#define USIC1_C0_DX2_P4_8   	1
#define USIC1_C0_DX2_P4_9   	2
#define USIC1_C0_DX3_DOUT0  	6
#define USIC1_C0_DX3_DX5INS 	5
#define USIC1_C0_DX3_P1_8   	1
#define USIC1_C0_DX3_P2_12  	0
#define USIC1_C0_DX3_P2_3   	4
#define USIC1_C0_DX3_P3_2   	2
#define USIC1_C0_DX3_P4_0   	3
#define USIC1_C0_DX4_DX5INS 	5
#define USIC1_C0_DX4_P1_8   	1
#define USIC1_C0_DX4_P2_12  	0
#define USIC1_C0_DX4_P2_3   	4
#define USIC1_C0_DX4_P3_2   	2
#define USIC1_C0_DX4_P4_0   	3
#define USIC1_C0_DX4_SCLKOUT	6
#define USIC1_C0_DX5_P1_7   	1
#define USIC1_C0_DX5_P2_13  	0
#define USIC1_C0_DX5_P2_2   	4
#define USIC1_C0_DX5_P2_4   	5
#define USIC1_C0_DX5_P4_1   	2
#define USIC1_C0_DX5_P4_2   	3
#define USIC1_C0_DX5_SELO0  	6
#define USIC1_C1_DX0_DX3INS 	6
#define USIC1_C1_DX0_P0_0   	0
#define USIC1_C1_DX0_P0_1   	1
#define USIC1_C1_DX0_P2_12  	2
#define USIC1_C1_DX0_P2_13  	3
#define USIC1_C1_DX0_P3_0   	4
#define USIC1_C1_DX0_P3_1   	5
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_DX4INS 	6
#define USIC1_C1_DX1_P0_1   	0
#define USIC1_C1_DX1_P1_8   	2
#define USIC1_C1_DX1_P2_12  	1
#define USIC1_C1_DX1_P3_0   	3
#define USIC1_C1_DX2_DX5INS 	6
#define USIC1_C1_DX2_P1_7   	2
#define USIC1_C1_DX2_P3_3   	0
#define USIC1_C1_DX2_P3_4   	1
#define USIC1_C1_DX2_SR0    	5
#define USIC1_C1_DX3_DOUT0  	6
#define USIC1_C1_DX3_DX5INS 	5
#define USIC1_C1_DX3_P0_15  	1
#define USIC1_C1_DX3_P2_4   	2
#define USIC1_C1_DX3_P2_6   	4
#define USIC1_C1_DX3_P3_2   	3
#define USIC1_C1_DX3_P4_11  	0
#define USIC1_C1_DX4_DX5INS 	5
#define USIC1_C1_DX4_P0_15  	1
#define USIC1_C1_DX4_P2_4   	2
#define USIC1_C1_DX4_P2_6   	4
#define USIC1_C1_DX4_P3_2   	3
#define USIC1_C1_DX4_P4_11  	0
#define USIC1_C1_DX4_SCLKOUT	6
#define USIC1_C1_DX5_P0_14  	1
#define USIC1_C1_DX5_P2_3   	2
#define USIC1_C1_DX5_P2_5   	3
#define USIC1_C1_DX5_P2_7   	4
#define USIC1_C1_DX5_P4_10  	0
#define USIC1_C1_DX5_P4_4   	5
#define USIC1_C1_DX5_SELO0  	6
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == VQFN40)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#define USIC1_C0_DX0_DX3INS 	6
#define USIC1_C0_DX0_P0_2   	0
#define USIC1_C0_DX0_P0_3   	1
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_DX4INS 	6
#define USIC1_C0_DX1_P0_2   	0
#define USIC1_C0_DX2_DX5INS 	6
#define USIC1_C0_DX3_DOUT0  	6
#define USIC1_C0_DX3_DX5INS 	5
#define USIC1_C0_DX3_P2_3   	4
#define USIC1_C0_DX4_DX5INS 	5
#define USIC1_C0_DX4_P2_3   	4
#define USIC1_C0_DX4_SCLKOUT	6
#define USIC1_C0_DX5_P2_2   	4
#define USIC1_C0_DX5_P2_4   	5
#define USIC1_C0_DX5_SELO0  	6
#define USIC1_C1_DX0_DX3INS 	6
#define USIC1_C1_DX0_P0_0   	0
#define USIC1_C1_DX0_P0_1   	1
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_DX4INS 	6
#define USIC1_C1_DX1_P0_1   	0
#define USIC1_C1_DX2_DX5INS 	6
#define USIC1_C1_DX2_SR0    	5
#define USIC1_C1_DX3_DOUT0  	6
#define USIC1_C1_DX3_DX5INS 	5
#define USIC1_C1_DX3_P0_15  	1
#define USIC1_C1_DX3_P2_4   	2
#define USIC1_C1_DX3_P2_6   	4
#define USIC1_C1_DX4_DX5INS 	5
#define USIC1_C1_DX4_P0_15  	1
#define USIC1_C1_DX4_P2_4   	2
#define USIC1_C1_DX4_P2_6   	4
#define USIC1_C1_DX4_SCLKOUT	6
#define USIC1_C1_DX5_P0_14  	1
#define USIC1_C1_DX5_P2_3   	2
#define USIC1_C1_DX5_P2_5   	3
#define USIC1_C1_DX5_P2_7   	4
#define USIC1_C1_DX5_SELO0  	6
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == VQFN48)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#define USIC1_C0_DX0_DX3INS 	6
#define USIC1_C0_DX0_P0_2   	0
#define USIC1_C0_DX0_P0_3   	1
#define USIC1_C0_DX0_P4_4   	2
#define USIC1_C0_DX0_P4_5   	3
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_DX4INS 	6
#define USIC1_C0_DX1_P0_2   	0
#define USIC1_C0_DX1_P4_5   	2
#define USIC1_C0_DX1_P4_6   	3
#define USIC1_C0_DX2_DX5INS 	6
#define USIC1_C0_DX2_P4_7   	0
#define USIC1_C0_DX3_DOUT0  	6
#define USIC1_C0_DX3_DX5INS 	5
#define USIC1_C0_DX3_P2_12  	0
#define USIC1_C0_DX3_P2_3   	4
#define USIC1_C0_DX4_DX5INS 	5
#define USIC1_C0_DX4_P2_12  	0
#define USIC1_C0_DX4_P2_3   	4
#define USIC1_C0_DX4_SCLKOUT	6
#define USIC1_C0_DX5_P2_13  	0
#define USIC1_C0_DX5_P2_2   	4
#define USIC1_C0_DX5_P2_4   	5
#define USIC1_C0_DX5_SELO0  	6
#define USIC1_C1_DX0_DX3INS 	6
#define USIC1_C1_DX0_P0_0   	0
#define USIC1_C1_DX0_P0_1   	1
#define USIC1_C1_DX0_P2_12  	2
#define USIC1_C1_DX0_P2_13  	3
#define USIC1_C1_DX0_P3_0   	4
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_DX4INS 	6
#define USIC1_C1_DX1_P0_1   	0
#define USIC1_C1_DX1_P2_12  	1
#define USIC1_C1_DX1_P3_0   	3
#define USIC1_C1_DX2_DX5INS 	6
#define USIC1_C1_DX2_SR0    	5
#define USIC1_C1_DX3_DOUT0  	6
#define USIC1_C1_DX3_DX5INS 	5
#define USIC1_C1_DX3_P0_15  	1
#define USIC1_C1_DX3_P2_4   	2
#define USIC1_C1_DX3_P2_6   	4
#define USIC1_C1_DX4_DX5INS 	5
#define USIC1_C1_DX4_P0_15  	1
#define USIC1_C1_DX4_P2_4   	2
#define USIC1_C1_DX4_P2_6   	4
#define USIC1_C1_DX4_SCLKOUT	6
#define USIC1_C1_DX5_P0_14  	1
#define USIC1_C1_DX5_P2_3   	2
#define USIC1_C1_DX5_P2_5   	3
#define USIC1_C1_DX5_P2_7   	4
#define USIC1_C1_DX5_P4_4   	5
#define USIC1_C1_DX5_SELO0  	6
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == VQFN64)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#define USIC1_C0_DX0_DX3INS 	6
#define USIC1_C0_DX0_P0_2   	0
#define USIC1_C0_DX0_P0_3   	1
#define USIC1_C0_DX0_P3_3   	4
#define USIC1_C0_DX0_P3_4   	5
#define USIC1_C0_DX0_P4_4   	2
#define USIC1_C0_DX0_P4_5   	3
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_DX4INS 	6
#define USIC1_C0_DX1_P0_2   	0
#define USIC1_C0_DX1_P3_4   	4
#define USIC1_C0_DX1_P4_3   	1
#define USIC1_C0_DX1_P4_5   	2
#define USIC1_C0_DX1_P4_6   	3
#define USIC1_C0_DX2_DX5INS 	6
#define USIC1_C0_DX2_P3_1   	5
#define USIC1_C0_DX2_P4_10  	3
#define USIC1_C0_DX2_P4_11  	4
#define USIC1_C0_DX2_P4_7   	0
#define USIC1_C0_DX2_P4_8   	1
#define USIC1_C0_DX2_P4_9   	2
#define USIC1_C0_DX3_DOUT0  	6
#define USIC1_C0_DX3_DX5INS 	5
#define USIC1_C0_DX3_P1_8   	1
#define USIC1_C0_DX3_P2_12  	0
#define USIC1_C0_DX3_P2_3   	4
#define USIC1_C0_DX3_P3_2   	2
#define USIC1_C0_DX3_P4_0   	3
#define USIC1_C0_DX4_DX5INS 	5
#define USIC1_C0_DX4_P1_8   	1
#define USIC1_C0_DX4_P2_12  	0
#define USIC1_C0_DX4_P2_3   	4
#define USIC1_C0_DX4_P3_2   	2
#define USIC1_C0_DX4_P4_0   	3
#define USIC1_C0_DX4_SCLKOUT	6
#define USIC1_C0_DX5_P1_7   	1
#define USIC1_C0_DX5_P2_13  	0
#define USIC1_C0_DX5_P2_2   	4
#define USIC1_C0_DX5_P2_4   	5
#define USIC1_C0_DX5_P4_1   	2
#define USIC1_C0_DX5_P4_2   	3
#define USIC1_C0_DX5_SELO0  	6
#define USIC1_C1_DX0_DX3INS 	6
#define USIC1_C1_DX0_P0_0   	0
#define USIC1_C1_DX0_P0_1   	1
#define USIC1_C1_DX0_P2_12  	2
#define USIC1_C1_DX0_P2_13  	3
#define USIC1_C1_DX0_P3_0   	4
#define USIC1_C1_DX0_P3_1   	5
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_DX4INS 	6
#define USIC1_C1_DX1_P0_1   	0
#define USIC1_C1_DX1_P1_8   	2
#define USIC1_C1_DX1_P2_12  	1
#define USIC1_C1_DX1_P3_0   	3
#define USIC1_C1_DX2_DX5INS 	6
#define USIC1_C1_DX2_P1_7   	2
#define USIC1_C1_DX2_P3_3   	0
#define USIC1_C1_DX2_P3_4   	1
#define USIC1_C1_DX2_SR0    	5
#define USIC1_C1_DX3_DOUT0  	6
#define USIC1_C1_DX3_DX5INS 	5
#define USIC1_C1_DX3_P0_15  	1
#define USIC1_C1_DX3_P2_4   	2
#define USIC1_C1_DX3_P2_6   	4
#define USIC1_C1_DX3_P3_2   	3
#define USIC1_C1_DX3_P4_11  	0
#define USIC1_C1_DX4_DX5INS 	5
#define USIC1_C1_DX4_P0_15  	1
#define USIC1_C1_DX4_P2_4   	2
#define USIC1_C1_DX4_P2_6   	4
#define USIC1_C1_DX4_P3_2   	3
#define USIC1_C1_DX4_P4_11  	0
#define USIC1_C1_DX4_SCLKOUT	6
#define USIC1_C1_DX5_P0_14  	1
#define USIC1_C1_DX5_P2_3   	2
#define USIC1_C1_DX5_P2_5   	3
#define USIC1_C1_DX5_P2_7   	4
#define USIC1_C1_DX5_P4_10  	0
#define USIC1_C1_DX5_P4_4   	5
#define USIC1_C1_DX5_SELO0  	6
#endif


#if (UC_DEVICE == XMC1402) && (UC_PACKAGE == TSSOP38)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#define USIC1_C0_DX0_DX3INS 	6
#define USIC1_C0_DX0_P0_2   	0
#define USIC1_C0_DX0_P0_3   	1
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_DX4INS 	6
#define USIC1_C0_DX1_P0_2   	0
#define USIC1_C0_DX2_DX5INS 	6
#define USIC1_C0_DX3_DOUT0  	6
#define USIC1_C0_DX3_DX5INS 	5
#define USIC1_C0_DX3_P2_3   	4
#define USIC1_C0_DX4_DX5INS 	5
#define USIC1_C0_DX4_P2_3   	4
#define USIC1_C0_DX4_SCLKOUT	6
#define USIC1_C0_DX5_P2_2   	4
#define USIC1_C0_DX5_P2_4   	5
#define USIC1_C0_DX5_SELO0  	6
#define USIC1_C1_DX0_DX3INS 	6
#define USIC1_C1_DX0_P0_0   	0
#define USIC1_C1_DX0_P0_1   	1
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_DX4INS 	6
#define USIC1_C1_DX1_P0_1   	0
#define USIC1_C1_DX2_DX5INS 	6
#define USIC1_C1_DX2_SR0    	5
#define USIC1_C1_DX3_DOUT0  	6
#define USIC1_C1_DX3_DX5INS 	5
#define USIC1_C1_DX3_P0_15  	1
#define USIC1_C1_DX3_P2_4   	2
#define USIC1_C1_DX3_P2_6   	4
#define USIC1_C1_DX4_DX5INS 	5
#define USIC1_C1_DX4_P0_15  	1
#define USIC1_C1_DX4_P2_4   	2
#define USIC1_C1_DX4_P2_6   	4
#define USIC1_C1_DX4_SCLKOUT	6
#define USIC1_C1_DX5_P0_14  	1
#define USIC1_C1_DX5_P2_3   	2
#define USIC1_C1_DX5_P2_5   	3
#define USIC1_C1_DX5_P2_7   	4
#define USIC1_C1_DX5_SELO0  	6
#endif


#if (UC_DEVICE == XMC1403) && (UC_PACKAGE == VQFN40)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#define USIC1_C0_DX0_DX3INS 	6
#define USIC1_C0_DX0_P0_2   	0
#define USIC1_C0_DX0_P0_3   	1
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_DX4INS 	6
#define USIC1_C0_DX1_P0_2   	0
#define USIC1_C0_DX2_DX5INS 	6
#define USIC1_C0_DX3_DOUT0  	6
#define USIC1_C0_DX3_DX5INS 	5
#define USIC1_C0_DX3_P2_3   	4
#define USIC1_C0_DX4_DX5INS 	5
#define USIC1_C0_DX4_P2_3   	4
#define USIC1_C0_DX4_SCLKOUT	6
#define USIC1_C0_DX5_P2_2   	4
#define USIC1_C0_DX5_P2_4   	5
#define USIC1_C0_DX5_SELO0  	6
#define USIC1_C1_DX0_DX3INS 	6
#define USIC1_C1_DX0_P0_0   	0
#define USIC1_C1_DX0_P0_1   	1
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_DX4INS 	6
#define USIC1_C1_DX1_P0_1   	0
#define USIC1_C1_DX2_DX5INS 	6
#define USIC1_C1_DX2_SR0    	5
#define USIC1_C1_DX3_DOUT0  	6
#define USIC1_C1_DX3_DX5INS 	5
#define USIC1_C1_DX3_P0_15  	1
#define USIC1_C1_DX3_P2_4   	2
#define USIC1_C1_DX3_P2_6   	4
#define USIC1_C1_DX4_DX5INS 	5
#define USIC1_C1_DX4_P0_15  	1
#define USIC1_C1_DX4_P2_4   	2
#define USIC1_C1_DX4_P2_6   	4
#define USIC1_C1_DX4_SCLKOUT	6
#define USIC1_C1_DX5_P0_14  	1
#define USIC1_C1_DX5_P2_3   	2
#define USIC1_C1_DX5_P2_5   	3
#define USIC1_C1_DX5_P2_7   	4
#define USIC1_C1_DX5_SELO0  	6
#endif


#if (UC_DEVICE == XMC1403) && (UC_PACKAGE == VQFN48)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#define USIC1_C0_DX0_DX3INS 	6
#define USIC1_C0_DX0_P0_2   	0
#define USIC1_C0_DX0_P0_3   	1
#define USIC1_C0_DX0_P4_4   	2
#define USIC1_C0_DX0_P4_5   	3
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_DX4INS 	6
#define USIC1_C0_DX1_P0_2   	0
#define USIC1_C0_DX1_P4_5   	2
#define USIC1_C0_DX1_P4_6   	3
#define USIC1_C0_DX2_DX5INS 	6
#define USIC1_C0_DX2_P4_7   	0
#define USIC1_C0_DX3_DOUT0  	6
#define USIC1_C0_DX3_DX5INS 	5
#define USIC1_C0_DX3_P2_12  	0
#define USIC1_C0_DX3_P2_3   	4
#define USIC1_C0_DX4_DX5INS 	5
#define USIC1_C0_DX4_P2_12  	0
#define USIC1_C0_DX4_P2_3   	4
#define USIC1_C0_DX4_SCLKOUT	6
#define USIC1_C0_DX5_P2_13  	0
#define USIC1_C0_DX5_P2_2   	4
#define USIC1_C0_DX5_P2_4   	5
#define USIC1_C0_DX5_SELO0  	6
#define USIC1_C1_DX0_DX3INS 	6
#define USIC1_C1_DX0_P0_0   	0
#define USIC1_C1_DX0_P0_1   	1
#define USIC1_C1_DX0_P2_12  	2
#define USIC1_C1_DX0_P2_13  	3
#define USIC1_C1_DX0_P3_0   	4
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_DX4INS 	6
#define USIC1_C1_DX1_P0_1   	0
#define USIC1_C1_DX1_P2_12  	1
#define USIC1_C1_DX1_P3_0   	3
#define USIC1_C1_DX2_DX5INS 	6
#define USIC1_C1_DX2_SR0    	5
#define USIC1_C1_DX3_DOUT0  	6
#define USIC1_C1_DX3_DX5INS 	5
#define USIC1_C1_DX3_P0_15  	1
#define USIC1_C1_DX3_P2_4   	2
#define USIC1_C1_DX3_P2_6   	4
#define USIC1_C1_DX4_DX5INS 	5
#define USIC1_C1_DX4_P0_15  	1
#define USIC1_C1_DX4_P2_4   	2
#define USIC1_C1_DX4_P2_6   	4
#define USIC1_C1_DX4_SCLKOUT	6
#define USIC1_C1_DX5_P0_14  	1
#define USIC1_C1_DX5_P2_3   	2
#define USIC1_C1_DX5_P2_5   	3
#define USIC1_C1_DX5_P2_7   	4
#define USIC1_C1_DX5_P4_4   	5
#define USIC1_C1_DX5_SELO0  	6
#endif


#if (UC_DEVICE == XMC1403) && (UC_PACKAGE == VQFN64)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#define USIC1_C0_DX0_DX3INS 	6
#define USIC1_C0_DX0_P0_2   	0
#define USIC1_C0_DX0_P0_3   	1
#define USIC1_C0_DX0_P3_3   	4
#define USIC1_C0_DX0_P3_4   	5
#define USIC1_C0_DX0_P4_4   	2
#define USIC1_C0_DX0_P4_5   	3
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_DX4INS 	6
#define USIC1_C0_DX1_P0_2   	0
#define USIC1_C0_DX1_P3_4   	4
#define USIC1_C0_DX1_P4_3   	1
#define USIC1_C0_DX1_P4_5   	2
#define USIC1_C0_DX1_P4_6   	3
#define USIC1_C0_DX2_DX5INS 	6
#define USIC1_C0_DX2_P3_1   	5
#define USIC1_C0_DX2_P4_10  	3
#define USIC1_C0_DX2_P4_11  	4
#define USIC1_C0_DX2_P4_7   	0
#define USIC1_C0_DX2_P4_8   	1
#define USIC1_C0_DX2_P4_9   	2
#define USIC1_C0_DX3_DOUT0  	6
#define USIC1_C0_DX3_DX5INS 	5
#define USIC1_C0_DX3_P1_8   	1
#define USIC1_C0_DX3_P2_12  	0
#define USIC1_C0_DX3_P2_3   	4
#define USIC1_C0_DX3_P3_2   	2
#define USIC1_C0_DX3_P4_0   	3
#define USIC1_C0_DX4_DX5INS 	5
#define USIC1_C0_DX4_P1_8   	1
#define USIC1_C0_DX4_P2_12  	0
#define USIC1_C0_DX4_P2_3   	4
#define USIC1_C0_DX4_P3_2   	2
#define USIC1_C0_DX4_P4_0   	3
#define USIC1_C0_DX4_SCLKOUT	6
#define USIC1_C0_DX5_P1_7   	1
#define USIC1_C0_DX5_P2_13  	0
#define USIC1_C0_DX5_P2_2   	4
#define USIC1_C0_DX5_P2_4   	5
#define USIC1_C0_DX5_P4_1   	2
#define USIC1_C0_DX5_P4_2   	3
#define USIC1_C0_DX5_SELO0  	6
#define USIC1_C1_DX0_DX3INS 	6
#define USIC1_C1_DX0_P0_0   	0
#define USIC1_C1_DX0_P0_1   	1
#define USIC1_C1_DX0_P2_12  	2
#define USIC1_C1_DX0_P2_13  	3
#define USIC1_C1_DX0_P3_0   	4
#define USIC1_C1_DX0_P3_1   	5
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_DX4INS 	6
#define USIC1_C1_DX1_P0_1   	0
#define USIC1_C1_DX1_P1_8   	2
#define USIC1_C1_DX1_P2_12  	1
#define USIC1_C1_DX1_P3_0   	3
#define USIC1_C1_DX2_DX5INS 	6
#define USIC1_C1_DX2_P1_7   	2
#define USIC1_C1_DX2_P3_3   	0
#define USIC1_C1_DX2_P3_4   	1
#define USIC1_C1_DX2_SR0    	5
#define USIC1_C1_DX3_DOUT0  	6
#define USIC1_C1_DX3_DX5INS 	5
#define USIC1_C1_DX3_P0_15  	1
#define USIC1_C1_DX3_P2_4   	2
#define USIC1_C1_DX3_P2_6   	4
#define USIC1_C1_DX3_P3_2   	3
#define USIC1_C1_DX3_P4_11  	0
#define USIC1_C1_DX4_DX5INS 	5
#define USIC1_C1_DX4_P0_15  	1
#define USIC1_C1_DX4_P2_4   	2
#define USIC1_C1_DX4_P2_6   	4
#define USIC1_C1_DX4_P3_2   	3
#define USIC1_C1_DX4_P4_11  	0
#define USIC1_C1_DX4_SCLKOUT	6
#define USIC1_C1_DX5_P0_14  	1
#define USIC1_C1_DX5_P2_3   	2
#define USIC1_C1_DX5_P2_5   	3
#define USIC1_C1_DX5_P2_7   	4
#define USIC1_C1_DX5_P4_10  	0
#define USIC1_C1_DX5_P4_4   	5
#define USIC1_C1_DX5_SELO0  	6
#endif


#if (UC_DEVICE == XMC1404) && (UC_PACKAGE == LQFP64)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#define USIC1_C0_DX0_DX3INS 	6
#define USIC1_C0_DX0_P0_2   	0
#define USIC1_C0_DX0_P0_3   	1
#define USIC1_C0_DX0_P3_3   	4
#define USIC1_C0_DX0_P3_4   	5
#define USIC1_C0_DX0_P4_4   	2
#define USIC1_C0_DX0_P4_5   	3
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_DX4INS 	6
#define USIC1_C0_DX1_P0_2   	0
#define USIC1_C0_DX1_P3_4   	4
#define USIC1_C0_DX1_P4_3   	1
#define USIC1_C0_DX1_P4_5   	2
#define USIC1_C0_DX1_P4_6   	3
#define USIC1_C0_DX2_DX5INS 	6
#define USIC1_C0_DX2_P3_1   	5
#define USIC1_C0_DX2_P4_10  	3
#define USIC1_C0_DX2_P4_11  	4
#define USIC1_C0_DX2_P4_7   	0
#define USIC1_C0_DX2_P4_8   	1
#define USIC1_C0_DX2_P4_9   	2
#define USIC1_C0_DX3_DOUT0  	6
#define USIC1_C0_DX3_DX5INS 	5
#define USIC1_C0_DX3_P1_8   	1
#define USIC1_C0_DX3_P2_12  	0
#define USIC1_C0_DX3_P2_3   	4
#define USIC1_C0_DX3_P3_2   	2
#define USIC1_C0_DX3_P4_0   	3
#define USIC1_C0_DX4_DX5INS 	5
#define USIC1_C0_DX4_P1_8   	1
#define USIC1_C0_DX4_P2_12  	0
#define USIC1_C0_DX4_P2_3   	4
#define USIC1_C0_DX4_P3_2   	2
#define USIC1_C0_DX4_P4_0   	3
#define USIC1_C0_DX4_SCLKOUT	6
#define USIC1_C0_DX5_P1_7   	1
#define USIC1_C0_DX5_P2_13  	0
#define USIC1_C0_DX5_P2_2   	4
#define USIC1_C0_DX5_P2_4   	5
#define USIC1_C0_DX5_P4_1   	2
#define USIC1_C0_DX5_P4_2   	3
#define USIC1_C0_DX5_SELO0  	6
#define USIC1_C1_DX0_DX3INS 	6
#define USIC1_C1_DX0_P0_0   	0
#define USIC1_C1_DX0_P0_1   	1
#define USIC1_C1_DX0_P2_12  	2
#define USIC1_C1_DX0_P2_13  	3
#define USIC1_C1_DX0_P3_0   	4
#define USIC1_C1_DX0_P3_1   	5
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_DX4INS 	6
#define USIC1_C1_DX1_P0_1   	0
#define USIC1_C1_DX1_P1_8   	2
#define USIC1_C1_DX1_P2_12  	1
#define USIC1_C1_DX1_P3_0   	3
#define USIC1_C1_DX2_DX5INS 	6
#define USIC1_C1_DX2_P1_7   	2
#define USIC1_C1_DX2_P3_3   	0
#define USIC1_C1_DX2_P3_4   	1
#define USIC1_C1_DX2_SR0    	5
#define USIC1_C1_DX3_DOUT0  	6
#define USIC1_C1_DX3_DX5INS 	5
#define USIC1_C1_DX3_P0_15  	1
#define USIC1_C1_DX3_P2_4   	2
#define USIC1_C1_DX3_P2_6   	4
#define USIC1_C1_DX3_P3_2   	3
#define USIC1_C1_DX3_P4_11  	0
#define USIC1_C1_DX4_DX5INS 	5
#define USIC1_C1_DX4_P0_15  	1
#define USIC1_C1_DX4_P2_4   	2
#define USIC1_C1_DX4_P2_6   	4
#define USIC1_C1_DX4_P3_2   	3
#define USIC1_C1_DX4_P4_11  	0
#define USIC1_C1_DX4_SCLKOUT	6
#define USIC1_C1_DX5_P0_14  	1
#define USIC1_C1_DX5_P2_3   	2
#define USIC1_C1_DX5_P2_5   	3
#define USIC1_C1_DX5_P2_7   	4
#define USIC1_C1_DX5_P4_10  	0
#define USIC1_C1_DX5_P4_4   	5
#define USIC1_C1_DX5_SELO0  	6
#endif


#if (UC_DEVICE == XMC1404) && (UC_PACKAGE == VQFN48)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#define USIC1_C0_DX0_DX3INS 	6
#define USIC1_C0_DX0_P0_2   	0
#define USIC1_C0_DX0_P0_3   	1
#define USIC1_C0_DX0_P4_4   	2
#define USIC1_C0_DX0_P4_5   	3
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_DX4INS 	6
#define USIC1_C0_DX1_P0_2   	0
#define USIC1_C0_DX1_P4_5   	2
#define USIC1_C0_DX1_P4_6   	3
#define USIC1_C0_DX2_DX5INS 	6
#define USIC1_C0_DX2_P4_7   	0
#define USIC1_C0_DX3_DOUT0  	6
#define USIC1_C0_DX3_DX5INS 	5
#define USIC1_C0_DX3_P2_12  	0
#define USIC1_C0_DX3_P2_3   	4
#define USIC1_C0_DX4_DX5INS 	5
#define USIC1_C0_DX4_P2_12  	0
#define USIC1_C0_DX4_P2_3   	4
#define USIC1_C0_DX4_SCLKOUT	6
#define USIC1_C0_DX5_P2_13  	0
#define USIC1_C0_DX5_P2_2   	4
#define USIC1_C0_DX5_P2_4   	5
#define USIC1_C0_DX5_SELO0  	6
#define USIC1_C1_DX0_DX3INS 	6
#define USIC1_C1_DX0_P0_0   	0
#define USIC1_C1_DX0_P0_1   	1
#define USIC1_C1_DX0_P2_12  	2
#define USIC1_C1_DX0_P2_13  	3
#define USIC1_C1_DX0_P3_0   	4
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_DX4INS 	6
#define USIC1_C1_DX1_P0_1   	0
#define USIC1_C1_DX1_P2_12  	1
#define USIC1_C1_DX1_P3_0   	3
#define USIC1_C1_DX2_DX5INS 	6
#define USIC1_C1_DX2_SR0    	5
#define USIC1_C1_DX3_DOUT0  	6
#define USIC1_C1_DX3_DX5INS 	5
#define USIC1_C1_DX3_P0_15  	1
#define USIC1_C1_DX3_P2_4   	2
#define USIC1_C1_DX3_P2_6   	4
#define USIC1_C1_DX4_DX5INS 	5
#define USIC1_C1_DX4_P0_15  	1
#define USIC1_C1_DX4_P2_4   	2
#define USIC1_C1_DX4_P2_6   	4
#define USIC1_C1_DX4_SCLKOUT	6
#define USIC1_C1_DX5_P0_14  	1
#define USIC1_C1_DX5_P2_3   	2
#define USIC1_C1_DX5_P2_5   	3
#define USIC1_C1_DX5_P2_7   	4
#define USIC1_C1_DX5_P4_4   	5
#define USIC1_C1_DX5_SELO0  	6
#endif


#if (UC_DEVICE == XMC1404) && (UC_PACKAGE == VQFN64)
#define USIC0_C0_DX0_DX3INS 	6
#define USIC0_C0_DX0_P0_14  	0
#define USIC0_C0_DX0_P0_15  	1
#define USIC0_C0_DX0_P1_0   	2
#define USIC0_C0_DX0_P1_1   	3
#define USIC0_C0_DX0_P2_0   	4
#define USIC0_C0_DX0_P2_1   	5
#define USIC0_C0_DX1_DX0INS 	5
#define USIC0_C0_DX1_DX4INS 	6
#define USIC0_C0_DX1_P0_14  	0
#define USIC0_C0_DX1_P0_7   	2
#define USIC0_C0_DX1_P0_8   	1
#define USIC0_C0_DX1_P1_1   	3
#define USIC0_C0_DX1_P2_0   	4
#define USIC0_C0_DX2_DX5INS 	6
#define USIC0_C0_DX2_P0_0   	0
#define USIC0_C0_DX2_P0_10  	2
#define USIC0_C0_DX2_P0_11  	3
#define USIC0_C0_DX2_P0_12  	4
#define USIC0_C0_DX2_P0_13  	5
#define USIC0_C0_DX2_P0_9   	1
#define USIC0_C0_DX3_DOUT0  	6
#define USIC0_C0_DX3_DX5INS 	5
#define USIC0_C0_DX3_P2_10  	2
#define USIC0_C0_DX3_P2_2   	0
#define USIC0_C0_DX3_P2_4   	1
#define USIC0_C0_DX3_P2_6   	4
#define USIC0_C0_DX3_P2_8   	3
#define USIC0_C0_DX4_DX5INS 	5
#define USIC0_C0_DX4_P2_10  	2
#define USIC0_C0_DX4_P2_2   	0
#define USIC0_C0_DX4_P2_4   	1
#define USIC0_C0_DX4_P2_6   	4
#define USIC0_C0_DX4_P2_8   	3
#define USIC0_C0_DX4_SCLKOUT	6
#define USIC0_C0_DX5_P1_4   	4
#define USIC0_C0_DX5_P1_6   	5
#define USIC0_C0_DX5_P2_3   	1
#define USIC0_C0_DX5_P2_5   	3
#define USIC0_C0_DX5_P2_7   	2
#define USIC0_C0_DX5_P2_9   	0
#define USIC0_C0_DX5_SELO0  	6
#define USIC0_C1_DX0_DX3INS 	6
#define USIC0_C1_DX0_P0_6   	2
#define USIC0_C1_DX0_P0_7   	3
#define USIC0_C1_DX0_P1_2   	1
#define USIC0_C1_DX0_P1_3   	0
#define USIC0_C1_DX0_P2_10  	5
#define USIC0_C1_DX0_P2_11  	4
#define USIC0_C1_DX1_DX0INS 	5
#define USIC0_C1_DX1_DX4INS 	6
#define USIC0_C1_DX1_P0_7   	2
#define USIC0_C1_DX1_P0_8   	1
#define USIC0_C1_DX1_P1_3   	0
#define USIC0_C1_DX1_P2_11  	4
#define USIC0_C1_DX2_DX5INS 	6
#define USIC0_C1_DX2_P0_0   	0
#define USIC0_C1_DX2_P0_10  	2
#define USIC0_C1_DX2_P0_11  	3
#define USIC0_C1_DX2_P0_9   	1
#define USIC0_C1_DX2_P1_1   	4
#define USIC0_C1_DX2_P2_0   	5
#define USIC0_C1_DX3_DOUT0  	6
#define USIC0_C1_DX3_DX5INS 	5
#define USIC0_C1_DX3_P2_1   	0
#define USIC0_C1_DX3_P2_3   	2
#define USIC0_C1_DX3_P2_5   	4
#define USIC0_C1_DX3_P2_7   	3
#define USIC0_C1_DX3_P2_9   	1
#define USIC0_C1_DX4_DX5INS 	5
#define USIC0_C1_DX4_P2_1   	0
#define USIC0_C1_DX4_P2_3   	2
#define USIC0_C1_DX4_P2_5   	4
#define USIC0_C1_DX4_P2_7   	3
#define USIC0_C1_DX4_P2_9   	1
#define USIC0_C1_DX4_SCLKOUT	6
#define USIC0_C1_DX5_P1_4   	4
#define USIC0_C1_DX5_P1_5   	5
#define USIC0_C1_DX5_P2_2   	0
#define USIC0_C1_DX5_P2_4   	1
#define USIC0_C1_DX5_P2_6   	3
#define USIC0_C1_DX5_P2_8   	2
#define USIC0_C1_DX5_SR0    	6
#define USIC1_C0_DX0_DX3INS 	6
#define USIC1_C0_DX0_P0_2   	0
#define USIC1_C0_DX0_P0_3   	1
#define USIC1_C0_DX0_P3_3   	4
#define USIC1_C0_DX0_P3_4   	5
#define USIC1_C0_DX0_P4_4   	2
#define USIC1_C0_DX0_P4_5   	3
#define USIC1_C0_DX1_DX0INS 	5
#define USIC1_C0_DX1_DX4INS 	6
#define USIC1_C0_DX1_P0_2   	0
#define USIC1_C0_DX1_P3_4   	4
#define USIC1_C0_DX1_P4_3   	1
#define USIC1_C0_DX1_P4_5   	2
#define USIC1_C0_DX1_P4_6   	3
#define USIC1_C0_DX2_DX5INS 	6
#define USIC1_C0_DX2_P3_1   	5
#define USIC1_C0_DX2_P4_10  	3
#define USIC1_C0_DX2_P4_11  	4
#define USIC1_C0_DX2_P4_7   	0
#define USIC1_C0_DX2_P4_8   	1
#define USIC1_C0_DX2_P4_9   	2
#define USIC1_C0_DX3_DOUT0  	6
#define USIC1_C0_DX3_DX5INS 	5
#define USIC1_C0_DX3_P1_8   	1
#define USIC1_C0_DX3_P2_12  	0
#define USIC1_C0_DX3_P2_3   	4
#define USIC1_C0_DX3_P3_2   	2
#define USIC1_C0_DX3_P4_0   	3
#define USIC1_C0_DX4_DX5INS 	5
#define USIC1_C0_DX4_P1_8   	1
#define USIC1_C0_DX4_P2_12  	0
#define USIC1_C0_DX4_P2_3   	4
#define USIC1_C0_DX4_P3_2   	2
#define USIC1_C0_DX4_P4_0   	3
#define USIC1_C0_DX4_SCLKOUT	6
#define USIC1_C0_DX5_P1_7   	1
#define USIC1_C0_DX5_P2_13  	0
#define USIC1_C0_DX5_P2_2   	4
#define USIC1_C0_DX5_P2_4   	5
#define USIC1_C0_DX5_P4_1   	2
#define USIC1_C0_DX5_P4_2   	3
#define USIC1_C0_DX5_SELO0  	6
#define USIC1_C1_DX0_DX3INS 	6
#define USIC1_C1_DX0_P0_0   	0
#define USIC1_C1_DX0_P0_1   	1
#define USIC1_C1_DX0_P2_12  	2
#define USIC1_C1_DX0_P2_13  	3
#define USIC1_C1_DX0_P3_0   	4
#define USIC1_C1_DX0_P3_1   	5
#define USIC1_C1_DX1_DX0INS 	5
#define USIC1_C1_DX1_DX4INS 	6
#define USIC1_C1_DX1_P0_1   	0
#define USIC1_C1_DX1_P1_8   	2
#define USIC1_C1_DX1_P2_12  	1
#define USIC1_C1_DX1_P3_0   	3
#define USIC1_C1_DX2_DX5INS 	6
#define USIC1_C1_DX2_P1_7   	2
#define USIC1_C1_DX2_P3_3   	0
#define USIC1_C1_DX2_P3_4   	1
#define USIC1_C1_DX2_SR0    	5
#define USIC1_C1_DX3_DOUT0  	6
#define USIC1_C1_DX3_DX5INS 	5
#define USIC1_C1_DX3_P0_15  	1
#define USIC1_C1_DX3_P2_4   	2
#define USIC1_C1_DX3_P2_6   	4
#define USIC1_C1_DX3_P3_2   	3
#define USIC1_C1_DX3_P4_11  	0
#define USIC1_C1_DX4_DX5INS 	5
#define USIC1_C1_DX4_P0_15  	1
#define USIC1_C1_DX4_P2_4   	2
#define USIC1_C1_DX4_P2_6   	4
#define USIC1_C1_DX4_P3_2   	3
#define USIC1_C1_DX4_P4_11  	0
#define USIC1_C1_DX4_SCLKOUT	6
#define USIC1_C1_DX5_P0_14  	1
#define USIC1_C1_DX5_P2_3   	2
#define USIC1_C1_DX5_P2_5   	3
#define USIC1_C1_DX5_P2_7   	4
#define USIC1_C1_DX5_P4_10  	0
#define USIC1_C1_DX5_P4_4   	5
#define USIC1_C1_DX5_SELO0  	6
#endif

#endif /* XMC1_USIC_MAP_H */
